//AIM: To implement a two stage decimator for the following specifications:
// Sampling rate of the input signal=20,000 Hz
//D=100,Passband=0 to 40Hz,Transition Band=40 to 50Hz,Passband ripple=0.02,Stopband ripple=0.002

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;

// Let us consider the combination 25*4
D1=25;
D2=4;
//such that D=D1*D2
F0=20000;//Fo is the sampling frequency(or sampling rate) of the input signal(given in the question)
Fp=40; //Fp is the passband edge frequency(given in the question)
Fstop=50; //Fstop is the stopband edge frequency(given in the question)
F1=F0/D1;
F2=F1/D2;
disp("Hertz",F0,"The given value of F0=")
disp("Hertz",F1,"The calculated value of F1=")
disp("Hertz",F2,"The calculated value of F2=")
Dp=0.02;
Ds=0.002;
// calculations for stage I...
//Step 1:Passband:0<=F<=Fp that means 0<= F<= 40 Hertz
//Step 2:Stopband: Fi-Fstop<=F<=F(i-1)/2
//Here i=1 for Stage-I
LROS1=F1-Fstop; //Here, LROS1=Lowest limit of stopband for Stage-I
HROS1=F0/2;//Here, HROS1=Highest limit of stopband for Stage-I
disp("Hertz",LROS1,"The lowest limit of stopband(for Stage-I) =")
disp("Hertz",HROS1,"The highest limit of stopband(for Stage-I) =")
disp("Hertz",HROS1,"<=F<=","Hertz",LROS1,"So the range of stopband for Stage I is:",)
Tmax1=LROS1;
Tmin1=Fp;
DF1=(Tmax1-Tmin1)/F0
Dp1=(Dp/2);
Ds1=Ds;
disp('Hertz',DF1,"The calculated value of ∆F1=")
disp(Dp1,"The calculated value of δp1=")
disp(Ds1,"The value of δs1=δs=")
N1=(((-10*log10(Dp1*Ds1)-13)/(14.6*DF1))+1); //Computing the filter length(N1) of Stage-I 
disp(N1,"Filter length,N1=")
NR1=int(N1);//Extracting only the integer part from N1
x1=N1-int(N1);//x1 is the decimal part of overall N1
if (x1>0) //If the decimal part is greater than zero
    NR1=NR1+1 //Then increment the extracted integer part i.e. NR1 by 1 to get a round-off value of the length of filter of Stage-I
disp(NR1,"Filter length N1(round-off value)now known as NR1=")
// calculations for stage-II...
//Step 1:Passband:0<=F<=Fp that means 0<= F<= 40 Hertz
//Step 2:Stopband: Fi-Fstop<=F<=F(i-1)/2
//Here i=2 for Stage-II
disp("--------------Now displaying the values for stage-II--------------")
LROS2=F2-Fstop; //Here, LROS2=Lowest limit of stopband for Stage-II
HROS2=F1/2//Here, HROS2=Highest limit of stopband for Stage-II
disp("Hertz",LROS2,"The lowest limit of stopband(for Stage-II) =")
disp("Hertz",HROS2,"The highest limit of stopband(for Stage-II) =")
disp("Hertz",HROS2,"<=F<=","Hertz",LROS2,"So the range of stopband for Stage-II is:",)
//If transition band is given in the question,then always given transition width is applicable for the second stage.
//Given transition width is 40Hz to 50Hz.
//It indicates that for this stage,the stopband should start at 50Hz.
a=50;
disp("Hertz",a,"The new value of the lowest limit of stopband(for Stage-II) =")
disp("Hertz",HROS2,"The highest limit of stopband is re-written(for Stage-II)which is =")
disp("Hertz",HROS2,"<=F<=","Hertz",a,"So the new modified range of stopband for Stage-II is:",)
Tmax2=50;
Tmin2=Fp;
DF2=(Tmax2-Tmin2)/F1
Dp2=(Dp/2);
Ds2=Ds;
disp('Hertz',DF2,"The calculated value of ∆F2=")
disp(Dp2,"The calculated value of δp2=")
disp(Ds2,"The value of δs2=δs1=δs=")
N2=(((-10*log10(Dp2*Ds2)-13)/(14.6*DF2))+1);//Computing the filter length (N2) of Stage-II
disp(N2,"Filter length,N2=")
NR2=int(N2);//Extracting only the integer part from N2
x2=N2-int(N2);//x is the decimal part of overall N2
if (x2>0)//If the decimal part is greater than zero
    NR2=NR2+1 //Then increment the extracted integer part i.e. NR2 by 1 to get a round-off value of the length of filter of Stage-II
disp(NR2,"Final filter length,N2(round-off value)now known as NR2=")
//Calculation of MPS(Multiplications per second) and TSR(Total Storage requirement)...
//MPS=Σ of [i=1 to I](Ni*Fi)
//Here I=Total No. of stages=2
MPS=(NR1*F1)+(NR2*F2); 
disp(MPS,"The value of No. of MPS(Multiplications per second)=")
//TSR=Σ of [i=1 to I](Ni)
//Here I=Total No. of stages=2
TSR=NR1+NR2
disp(TSR,"The value of TSR(Total storage requirement)=")
